/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.container.item.ItemContainer;
import com.technicalitiesmc.lib.container.item.SimpleItemContainer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BlockInventory
extends BlockComponent.WithData<Data> {
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private static final UpdateCallback EMPTY_CALLBACK = ($, $$, $$$, $$$$) -> {};
    private final InventoryFactory inventoryFactory;
    private final boolean shouldDropItemsOnBreak;
    private final boolean shouldOutputToComparators;
    private final boolean shouldExposeCaps;
    private final boolean shouldSendToClients;
    private final UpdateCallback updateCallback;

    private BlockInventory(BlockComponent.Context context, InventoryFactory inventoryFactory, EnumSet<Flag> flags, @Nullable UpdateCallback updateCallback) {
        super(context, Data::new);
        this.inventoryFactory = inventoryFactory;
        this.shouldDropItemsOnBreak = flags.contains((Object)Flag.DROP_ON_BREAK);
        this.shouldOutputToComparators = flags.contains((Object)Flag.COMPARATOR_OUTPUT);
        this.shouldExposeCaps = flags.contains((Object)Flag.EXPOSE_ITEM_HANDLER);
        this.shouldSendToClients = flags.contains((Object)Flag.SEND_TO_CLIENTS);
        this.updateCallback = updateCallback != null ? updateCallback : EMPTY_CALLBACK;
    }

    public static BlockComponent.Constructor<BlockInventory> of(int slots, @Nullable UpdateCallback updateCallback, Flag ... flags) {
        return BlockInventory.of(callback -> new SimpleItemContainer(slots, callback), updateCallback, flags);
    }

    public static BlockComponent.Constructor<BlockInventory> of(InventoryFactory inventoryFactory, @Nullable UpdateCallback updateCallback, Flag ... flags) {
        return context -> new BlockInventory(context, inventoryFactory, flags.length != 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(Flag.class), updateCallback);
    }

    @Nullable
    public ItemContainer at(BlockGetter level, BlockPos pos, BlockState state) {
        Data data = (Data)this.getData(level, pos, state);
        return data == null ? null : data.inventory;
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!moving && this.shouldDropItemsOnBreak && !state.m_60713_(newState.m_60734_())) {
            Data data = (Data)this.getData((BlockGetter)level, pos, state);
            if (data != null) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)data.inventory.asVanillaContainer());
            }
            level.m_46717_(pos, (Block)this.getBlock());
        }
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        if (this.shouldOutputToComparators) {
            Data data = (Data)this.getData((BlockGetter)level, pos, state);
            return data == null ? 0 : AbstractContainerMenu.m_38938_((Container)data.inventory.asVanillaContainer());
        }
        return 0;
    }

    @FunctionalInterface
    public static interface InventoryFactory {
        public ItemContainer.Serializable createInventory(Runnable var1);
    }

    public static enum Flag {
        COMPARATOR_OUTPUT,
        DROP_ON_BREAK,
        EXPOSE_ITEM_HANDLER,
        SEND_TO_CLIENTS;

    }

    @FunctionalInterface
    public static interface UpdateCallback {
        public void onUpdated(Level var1, BlockPos var2, BlockState var3, ItemContainer var4);
    }

    public static class Data
    extends BlockComponentData<BlockInventory> {
        private final ItemContainer.Serializable inventory;
        private final LazyOptional<IItemHandler> itemHandler;

        private Data(BlockComponentData.Context context) {
            super(context);
            BlockInventory component = (BlockInventory)this.getComponent();
            this.inventory = component.inventoryFactory.createInventory(this::onInventoryUpdate);
            this.itemHandler = component.shouldExposeCaps ? LazyOptional.of(this.inventory::asItemHandler) : LazyOptional.empty();
        }

        private void onInventoryUpdate() {
            BlockInventory component = (BlockInventory)this.getComponent();
            component.updateCallback.onUpdated(this.getLevel(), this.getBlockPos(), this.getBlockState(), this.inventory);
            this.markUnsaved();
            if (component.shouldOutputToComparators) {
                this.updateComparators();
            }
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ITEM_HANDLER_CAPABILITY) {
                return this.itemHandler.cast();
            }
            return super.getCapability(cap, side);
        }

        @Override
        public void invalidateCaps() {
            this.itemHandler.invalidate();
        }

        @Override
        public CompoundTag save(CompoundTag tag) {
            tag.m_128365_("inventory", (Tag)this.inventory.save());
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            this.inventory.load(tag.m_128469_("inventory"));
        }

        @Override
        public CompoundTag saveDescription(CompoundTag tag) {
            if (((BlockInventory)this.getComponent()).shouldSendToClients) {
                tag.m_128365_("inventory", (Tag)this.inventory.save());
            }
            return tag;
        }

        @Override
        public void loadDescription(CompoundTag tag) {
            if (((BlockInventory)this.getComponent()).shouldSendToClients) {
                this.inventory.load(tag.m_128469_("inventory"));
            }
        }
    }
}

